import os
from pydantic import BaseSettings

class Settings(BaseSettings):
    OPENAI_API_KEY: str
    OPENAI_API_BASE: str = "https://api.openai.com/v1"
    CACHE_REDIS_URL: str = "redis://redis:6379/0"
    MAX_TOKENS: int = 2048
    MODEL: str = "gpt-5"
    RATE_LIMIT_PER_MIN: int = 120

    class Config:
        env_file = "/app/.env"

settings = Settings()
