#!/bin/bash
# Server tuning snippets for HP DL580 Gen9
set -e
echo "1) Update and install basics"
sudo apt update && sudo apt upgrade -y
sudo apt install -y build-essential dkms linux-headers-$(uname -r) curl gnupg lsb-release

echo "2) Enable HugePages (example)"
sudo sysctl -w vm.nr_hugepages=1024

echo "3) Network tuning"
sudo sysctl -w net.core.somaxconn=65535
sudo sysctl -w net.ipv4.tcp_tw_reuse=1

echo "4) Docker + NVIDIA toolkit install (summary - follow vendor docs)"
# See official NVIDIA Container Toolkit install instructions
