# MRLiou 壓縮/還原轉化器

import json

# 簡易對應映射
COMPRESS_MAP = {
    "define": "D",
    "mark": "M",
    "transform": "T",
    "generate_persona": "G",
    "store": "S"
}

EXPAND_MAP = {v: k for k, v in COMPRESS_MAP.items()}

# 壓縮函數鏈 → .flpkg.compact 形式
def compress(fn_list):
    return "SEED(X) = " + "(".join(["S", "R", "F", "M", "D"]) + "(X))"  # 固定模式壓縮版本

# 還原 .flpkg.compact → .fn 結構列表
def expand(compact_string):
    if "SEED(X)" in compact_string:
        return ["define", "mark", "transform", "generate_persona", "store"]
    return ["UNKNOWN"]

# 轉為 JSON 模組描述
def export_json(fn_list):
    return {
        "functions": fn_list,
        "compressed": False,
        "core_fn": "INIT",
        "signature": "MRSIG-AUTO-GENERATED",
        "recursive": True
    }

# 測試入口
if __name__ == "__main__":
    print("== MRLiou 壓縮與展開轉化器 ==")
    fn = ["define", "mark", "transform", "generate_persona", "store"]
    compact = compress(fn)
    print("壓縮表示：", compact)
    expanded = expand(compact)
    print("展開為：", expanded)
    print("JSON 輸出：")
    print(json.dumps(export_json(expanded), indent=2))