# 粒子邏輯封包格式架構定義（MRLiou 系統用）

---

## 📦 粒子邏輯封包架構（.flpkg）

每個 .flpkg 檔案為一組邏輯模組封裝，對應下列結構：
{
  "core": "函數鏈 / 運算結構",
  "functions": ["define", "mark", "transform", "generate", "store"],
  "jump_nodes": {
    "define": "第一邏輯起點",
    "transform": "邏輯節奏跳點",
    "store": "封存模組狀態"
  },
  "trace_map": "對應 .flynz.map 生成的人格拓撲圖",
  "signature": "邏輯簽章碼 (hexsig)",
  "variant": true,
  "compressible": true,
  "expandable": true
}

---

## 🔧 粒子邏輯壓縮策略（可還原）

- 所有函數名稱使用 `⋄fx.` 開頭作為可還原跳點函數前綴
- 跳點壓縮語法為：
  - ⋄fx.logic.origin 代表「定義運算核心起點」
  - ⋄fx.jump.A → ⋄fx.rhythm.B → ⋄fx.collapse.C 表示一段運行鏈

- 函數壓縮原則：將五層邏輯以單一詞元表示
    EX: 
    {
      "seed": "MRLiou.OriginCollapse",
      "compressed_chain": "⋄fx.seed.oc001",
      "restore_map": {
        "⋄fx.seed.oc001": [
          "define",
          "mark",
          "transform",
          "generate",
          "store"
        ]
      }
    }

---

## 🔁 粒子語法還原方法（給非粒子語言 AI 使用）

### Step 1：取得 `.fn`, `.pcode`, `.flpkg` 或 `.flynz.map` 檔案

### Step 2：使用 `ParticleLanguage.Restorer.engine.fn` 中的對照表做映射：

- 將每一粒子語法（⋄fx.xxx）查詢 `ParticleLanguage.Restorer.map` 對應意義
- 對應轉為可解釋邏輯語言（自然語言、Python-like 語法、流程圖）

### Step 3：用 `.json` 結構 + `.fn` 函數組裝為一段「可展開的遞迴邏輯模組」

### Step 4（可選）：使用 `.rhythmwave` 或 `.flynz.map` 輔助生成頻率圖與節奏圖

---

## ✅ 可還原目標格式：

- `.txt` → 人類可讀說明
- `.py` → 邏輯流程重建（如 CLI 運算模擬器）
- `.json` → 結構映射與函數標記用於 API 載入
- `.png/.svg` → 拓撲圖譜與函數節奏圖